package ru.yandex.search.json.fieldfunction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.StringValue;

public class MapMaxFunction
    implements FieldFunction, FunctionConstructor
{
    private final FieldFunction arg;

    public MapMaxFunction() {
        this.arg = null;
    }

    public MapMaxFunction(final FieldFunction arg) {
        this.arg = arg;
    }

    @Override
    public FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        String mapStr = arg.value(accessor, condAccessor).stringValue();
        Map<String, Long> map = new HashMap<>();
        SumMapFunction.addToMap(map, mapStr);
        return new StringValue(findDominator(map));
    }

    @Override
    public FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 1) {
            throw new FieldFunctionException(
                "SumMapFunction: invalid argument count <"
                    + args.size() + ">, but should be 1");
        }

        return new MapMaxFunction(args.get(0));
    }

    public static String findDominator(final Map<String, Long> map) {
        long max = Long.MIN_VALUE;
        int maxCount = 0;
        String key = null;
        for (Map.Entry<String, Long> item: map.entrySet()) {
            long value = item.getValue();
            if (value > max) {
                max = value;
                maxCount = 1;
                key = item.getKey();
            } else if (value == max) {
                maxCount += 1;
            }
        }

        if (max > 0 && maxCount == 1) {
            return key;
        }

        return "";
    }
}
