package ru.yandex.search.json.fieldfunction;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.StringValue;

public class MapSetFunction
    implements FieldFunction, FunctionConstructor
{
    private final List<FieldFunction> args;

    public MapSetFunction() {
        this.args = null;
    }

    public MapSetFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        String mapStr = args.get(0).value(accessor, condAccessor).stringValue();

        Map<String, Long> map;
        if (args.size() <= 3) {
            map = new HashMap<>();
        } else {
            long maxValue = args.get(3).value(accessor, condAccessor).intValue();
            if (maxValue > Integer.MAX_VALUE) {
                throw new FieldFunctionException("Max elements param should be int");
            }

            int initial = Math.max(10 + mapStr.length() / 4, (int) maxValue);
            map = new LruMap(initial, (int) maxValue);
        }

        SumMapFunction.addToMap(map, mapStr);
        map.put(
            args.get(1).value(accessor, condAccessor).stringValue(),
            args.get(2).value(accessor, condAccessor).intValue());
        return new StringValue(SumMapFunction.mapToString(map));
    }


    @Override
    public FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 3 && args.size() != 4) {
            throw new FieldFunctionException(
                "MapGetFunction: invalid argument count <"
                    + args.size()
                    + ">, but should be 3 or 4 (map_field, key, value[, max_size])");
        }

        return new MapSetFunction(args);
    }

    protected static final class LruMap
        extends LinkedHashMap<String, Long>
    {
        private static final long serialVersionUID = 0L;

        private final int maxSize;

        LruMap(final int initial, final int maxSize) {
            super(initial);

            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(
            final Map.Entry<String, Long> eldest)
        {
            return size() > maxSize;
        }
    }
}
