package ru.yandex.search.json.fieldfunction;

import java.net.InetAddress;
import java.net.UnknownHostException;

import ru.yandex.search.json.fieldfunction.value.StringValue;

public class NormalizeIpFunction implements FieldFunction {
    private final FieldFunction arg;

    public NormalizeIpFunction(final FieldFunction arg) {
        this.arg = arg;
    }

    @Override
    public StringValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        String value = arg.value(accessor, condAccessor).stringValue();
        try {
            return new StringValue(
                InetAddress.getByName(value).getHostAddress());
        } catch (UnknownHostException e) {
            throw new FieldFunctionException(
                "Malformed IP: " + value,
                e);
        }
    }

    @Override
    public String toString() {
        return "NormalizeIpFunction(" + arg + ')';
    }
}

