package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.BooleanValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class NotFunction implements FieldFunction, FunctionConstructor {
    private final FieldFunction arg;

    public NotFunction() {
        arg = null;
    }

    public NotFunction(final FieldFunction arg) {
        this.arg = arg;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        boolean value = arg.value(accessor, condAccessor).booleanValue();
        return BooleanValue.valueOf(!value);
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 1) {
            throw new FieldFunctionException(
                "NotFunction: invalid argument count <"
                + args.size() + ">, but should be 1");
        }
        return new NotFunction(args.get(0));
    }

    @Override
    public String toString() {
        return "NotFunction(" + arg + ')';
    }
}
