package ru.yandex.search.json.fieldfunction;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.StringValue;
import ru.yandex.util.string.StringUtils;

public class RemoveSetFunction implements FieldFunction, FunctionConstructor {
    public static final String REMOVE_SET = "remove_set";

    private final FieldFunction arg1;
    private final FieldFunction arg2;

    public RemoveSetFunction() {
        arg1 = null;
        arg2 = null;
    }

    public RemoveSetFunction(
        final FieldFunction arg1,
        final FieldFunction arg2)
    {
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        return new StringValue(
            makeSet(
                arg1.value(accessor, condAccessor).stringValue(),
                arg2.value(accessor, condAccessor).stringValue()));
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != 2) {
            throw new FieldFunctionException(
                "RemoveSetFunction: invalid argument count <"
                    + args.size() + ">, but should be 2");
        }

        return new RemoveSetFunction(args.get(0), args.get(1));
    }

    @Override
    public String toString() {
        return "RemoveSetFunction(" + arg1
            + ',' + ' ' + arg2 + ')';
    }

    private static String makeSet(
        final String toDelete,
        final String deleteFrom)
    {
        Set<String> toDeleteSet = new LinkedHashSet<>();
        MakeSetFunction.addToSet(toDeleteSet, toDelete, Integer.MAX_VALUE);
        Set<String> deleteFromSet = new LinkedHashSet<>();
        MakeSetFunction.addToSet(deleteFromSet, deleteFrom, Integer.MAX_VALUE);

        deleteFromSet.removeAll(toDeleteSet);
        return StringUtils.join(deleteFromSet, '\n');
    }
}
