package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class SetFunction implements FieldFunction, FunctionConstructor {
    private final FieldFunction value;
    private final FieldFunction condition;
    private final String fieldName;

    public SetFunction() {
        value = null;
        condition = null;
        fieldName = null;
    }

    public SetFunction(final FieldFunction value, final FieldFunction condition, String fieldName) {
        this.value = value;
        this.condition = condition;
        this.fieldName = fieldName;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        if (condition == null
            || condition.value(accessor, condAccessor).booleanValue()) {
            return value.value(accessor, condAccessor);
        } else {
            return accessor.getFieldValue(fieldName);
        }
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        final FieldFunction ret;
        switch (args.size()) {
            case 1:
                ret = new SetFunction(args.get(0), null, fieldName);
                break;
            case 2:
                ret = new SetFunction(args.get(0), args.get(1), fieldName);
                break;
            default:
                throw new FieldFunctionException(
                    "SetFunction: invalid argument count <" + args.size()
                        + ">, but should be 1 or 2");
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder desc = new StringBuilder("SetFunction( ");
        desc.append(value);
        if (condition != null) {
            desc.append(", ");
            desc.append(condition);
        }
        desc.append(')');
        return  desc.toString();
    }
}
