package ru.yandex.search.json.fieldfunction;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.FunctionValue;
import ru.yandex.search.json.fieldfunction.value.StringValue;
import ru.yandex.util.string.StringUtils;

public class SumQueueFunction
    implements FieldFunction, FunctionConstructor
{
    private static final int NUM_ARGS = 3;

    private final FieldFunction arg1;
    private final FieldFunction arg2;
    private final FieldFunction sizeArg;

    public SumQueueFunction() {
        this.arg1 = null;
        this.arg2 = null;
        this.sizeArg = null;
    }

    public SumQueueFunction(
        final FieldFunction arg1,
        final FieldFunction arg2,
        final FieldFunction arg3)
    {
        this.arg1 = arg1;
        this.arg2 = arg2;

        this.sizeArg = arg3;
    }

    @Override
    public FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() != NUM_ARGS) {
            throw new FieldFunctionException(
                "SumQueueFunction: invalid argument count <"
                    + args.size() + ">, but should be 3");
        }

        return new SumQueueFunction(
            args.get(0),
            args.get(1),
            args.get(2));
    }

    @Override
    public FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        return new StringValue(
            updateMap(
                arg1.value(accessor, condAccessor).stringValue(),
                arg2.value(accessor, condAccessor).stringValue(),
                sizeArg.value(accessor, condAccessor).intValue()));
    }

    protected String updateMap(
        final String first,
        final String second,
        final long size)
        throws FieldFunctionException
    {
        Map<String, Long> map = new LinkedHashMap<>();
        this.addToMap(map, first);
        this.addToMap(map, second);

        return mapToString(map, size);
    }

    /**
     * For backward compatibility, (history request mid)
     * @param map
     * @param s
     * @throws FieldFunctionException
     */
    protected void addToMap(
        final Map<String, Long> map,
        final String s)
        throws FieldFunctionException
    {
        String trim = s.trim();
        if (trim.equals(SumMapFunction.EMPTY_VALUE)
            || trim.isEmpty()
            || trim.contains(SumMapFunction.KV_SEPARATOR))
        {
            SumMapFunction.addToMap(map, trim);
        } else {
            SumMapFunction.addToMap(
                map,
                StringUtils.concat(trim, SumMapFunction.KV_SEPARATOR, "1"));
        }
    }

    public static String mapToString(
        final Map<String, Long> map,
        final long size)
    {
        StringBuilder sb = new StringBuilder();
        int indexed = 0;
        for (Map.Entry<String, Long> entry: map.entrySet()) {
            if (indexed >= size) {
                break;
            }

            sb.append(entry.getKey());
            sb.append(SumMapFunction.KV_SEPARATOR);
            sb.append(entry.getValue());
            sb.append(SumMapFunction.RECORD_SEPARATOR);
            indexed += 1;
        }

        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }

        return sb.toString();
    }
}
