package ru.yandex.search.json.fieldfunction;

import java.util.List;
import java.util.Map;

import ru.yandex.search.json.fieldfunction.value.BooleanValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

public class XorFunction implements FieldFunction, FunctionConstructor {
    private final List<FieldFunction> args;

    public XorFunction() {
        args = null;
    }

    public XorFunction(final List<FieldFunction> args) {
        this.args = args;
    }

    @Override
    public final FunctionValue value(
        final FieldAccessor accessor,
        final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        boolean value =
            args.get(0).value(accessor, condAccessor).booleanValue();
        for (int i = 1; i < args.size(); i++) {
            value = value
                ^ args.get(i).value(accessor, condAccessor).booleanValue();
        }
        return BooleanValue.valueOf(value);
    }

    @Override
    public final FieldFunction construct(
        final String fieldName,
        final List<FieldFunction> args,
        final Map<String, String> conditions)
        throws FieldFunctionException
    {
        if (args.size() < 2) {
            throw new FieldFunctionException(
                "XorFunction: invalid argument count <"
                + args.size() + ">, but should be at least 2");
        }
        return new XorFunction(args);
    }

    @Override
    public String toString() {
        return "XorFunction( " + args + ')';
    }
}
