package ru.yandex.search.json.fieldfunction.value;

public class BooleanValue implements FunctionValue {
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    private final boolean value;

    private BooleanValue(final boolean value) {
        this.value = value;
    }

    public static BooleanValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public long intValue() {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public double floatValue() {
        if (value) {
            return 1.0;
        } else {
            return 0.0;
        }
    }

    @Override
    public boolean booleanValue() {
        return value;
    }

    @Override
    public String stringValue() {
        return Boolean.toString(value);
    }

    @Override
    public boolean equalsTo(final FunctionValue other) {
        if (other == this) {
            return true;
        }
        return value == other.booleanValue();
    }

    @Override
    public int compare(final FunctionValue other) {
        if (other == this) {
            return 0;
        }
        return Boolean.compare(value, other.booleanValue());
    }

    @Override
    public String toString() {
        return "BooleanValue(" + value + ')';
    }
}

