package ru.yandex.search.json.fieldfunction.value;

public enum DefaultValue implements FunctionValue {
    INSTANCE;

    @Override
    public long intValue() {
        return 0L;
    }

    @Override
    public double floatValue() {
        return 0d;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public String stringValue() {
        return "";
    }

    //CSOFF: ReturnCount
    @Override
    public boolean equalsTo(final FunctionValue other) {
        if (other == this) {
            return true;
        } else if (other instanceof StringValue) {
            return other.stringValue().length() == 0;
        } else if (other instanceof IntValue) {
            return other.intValue() == 0L;
        } else if (other instanceof FloatValue) {
            return other.floatValue() == 0d;
        }
        return !other.booleanValue();
    }

    @Override
    public int compare(final FunctionValue other) {
        if (other == this) {
            return 0;
        } else if (other instanceof StringValue) {
            return "".compareTo(other.stringValue());
        } else if (other instanceof IntValue) {
            return Long.compare(0L, other.intValue());
        } else if (other instanceof FloatValue) {
            return Double.compare(0d, other.floatValue());
        }
        return Boolean.compare(false, other.booleanValue());
    }
    //CSON: ReturnCount

    @Override
    public String toString() {
        return "DefaultValue()";
    }
}
