package ru.yandex.search.json.fieldfunction.value;

public class FloatValue implements FunctionValue {
    private final double value;

    public FloatValue(final double value) {
        this.value = value;
    }

    public FloatValue(final FunctionValue value) {
        this.value = value.floatValue();
    }

    @Override
    public long intValue() {
        return (long) value;
    }

    @Override
    public double floatValue() {
        return value;
    }

    @Override
    public boolean booleanValue() {
        return (long) value != 0;
    }

    @Override
    public String stringValue() {
        return Double.toString(value);
    }

    @Override
    public boolean equalsTo(final FunctionValue other) {
        if (other == this) {
            return true;
        }
        return Double.compare(value, other.floatValue()) == 0;
    }

    @Override
    public int compare(final FunctionValue other) {
        if (other == this) {
            return 0;
        }
        return Double.compare(value, other.floatValue());
    }

    @Override
    public String toString() {
        return "FloatValue(" + value + ')';
    }
}

