package ru.yandex.search.json.fieldfunction.value;

public class IntValue implements FunctionValue {
    private final long value;

    public IntValue(final long value) {
        this.value = value;
    }

    public IntValue(final FunctionValue value) {
        this.value = value.intValue();
    }

    @Override
    public long intValue() {
        return value;
    }

    @Override
    public double floatValue() {
        return (double) value;
    }

    @Override
    public boolean booleanValue() {
        return value != 0;
    }

    @Override
    public String stringValue() {
        return Long.toString(value);
    }

    @Override
    public boolean equalsTo(final FunctionValue other) {
        if (other == this) {
            return true;
        }
        return value == other.intValue();
    }

    @Override
    public int compare(final FunctionValue other) {
        if (other == this) {
            return 0;
        }
        return Long.compare(value, other.intValue());
    }

    @Override
    public String toString() {
        return "IntValue(" + value + ')';
    }
}

