package ru.yandex.search.json.fieldfunction.value;

public class StringValue implements FunctionValue {
    private final String value;

    public StringValue(final String value) {
        this.value = value;
    }

    public StringValue(final FunctionValue value) {
        this.value = value.stringValue();
    }

    @Override
    public long intValue() {
        return Long.parseLong(value);
    }

    private long intValueSafe() {
        try {
            return Long.parseLong(value);
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public double floatValue() {
        return Double.parseDouble(value);
    }

    @Override
    public String stringValue() {
        return value;
    }

    @Override
    public boolean booleanValue() {
        final boolean ret;
        if ("true".equalsIgnoreCase(value)) {
            ret = true;
        } else if (intValueSafe() != 0) {
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean equalsTo(final FunctionValue other) {
        if (other == this) {
            return true;
        }
        return value.equals(other.stringValue());
    }

    @Override
    public int compare(final FunctionValue other) {
        if (other == this) {
            return 0;
        }
        return value.compareTo(other.stringValue());
    }

    @Override
    public String toString() {
        return "StringValue(" + value + ')';
    }
}
