package ru.yandex.search.json.fieldfunction.value;

import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.function.GenericBiFunction;
import ru.yandex.search.json.BiOperationFilter;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;

public enum ValueType implements Function<BiOperationFilter, GenericBiFunction<FunctionValue, FunctionValue,
        FunctionValue, FieldFunctionException>> {
    BOOLEAN {
        @Nonnull
        @Override
        public GenericBiFunction<FunctionValue, FunctionValue, FunctionValue, FieldFunctionException> apply(@Nonnull BiOperationFilter biOp) {
            return (left, right) -> biOp.apply(left.booleanValue(), right.booleanValue());
        }
    },
    FLOAT {
        @Nonnull
        @Override
        public GenericBiFunction<FunctionValue, FunctionValue, FunctionValue, FieldFunctionException> apply(@Nonnull BiOperationFilter biOp) {
            return (left, right) -> biOp.apply(left.floatValue(), right.floatValue());
        }
    },
    INT {
        @Nonnull
        @Override
        public GenericBiFunction<FunctionValue, FunctionValue, FunctionValue, FieldFunctionException> apply(@Nonnull BiOperationFilter biOp) {
            return (left, right) -> biOp.apply(left.intValue(), right.intValue());
        }
    },
    STRING {
        @Nonnull
        @Override
        public GenericBiFunction<FunctionValue, FunctionValue, FunctionValue, FieldFunctionException> apply(@Nonnull BiOperationFilter biOp) {
            return (left, right) -> biOp.apply(left.stringValue(), right.stringValue());
        }
    },
    AUTO {
        @Nonnull
        @Override
        public GenericBiFunction<FunctionValue, FunctionValue, FunctionValue, FieldFunctionException> apply(@Nonnull BiOperationFilter biOp) {
            return biOp::apply;
        }
    },
}
