package ru.yandex.search.prefix;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.unsafe.NativeMemory2;

public class LongPrefix implements Prefix {
    // Most blackbox uids ends somewhere near 1130000000000000
    // see https://wiki.yandex-team.ru/passport/uids/
    private static final int LONG_STRING_LENGTH = 16;

    private final long prefix;

    public LongPrefix(final long prefix) {
        this.prefix = prefix;
    }

    public long prefix() {
        return prefix;
    }

    @Override
    public PrefixType type() {
        return PrefixType.LONG;
    }

    @Override
    public long hash() {
        return prefix;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(prefix);
    }

    @Override
    public boolean equals(final Object o) {
        return o == this
            || ((o instanceof LongPrefix)
                && prefix == ((LongPrefix) o).prefix);
    }

    @Override
    public String toString() {
        return Long.toString(prefix);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(prefix);
    }

    @Override
    public int sizeInBytes() {
        return Long.BYTES;
    }

    //CSOFF: Magic
    @Override
    public void writeTo(final byte[] out, final int offset) {
        int i = offset;
        out[i++] = (byte) (prefix >> 56);
        out[i++] = (byte) (prefix >> 48);
        out[i++] = (byte) (prefix >> 40);
        out[i++] = (byte) (prefix >> 32);
        out[i++] = (byte) (prefix >> 24);
        out[i++] = (byte) (prefix >> 16);
        out[i++] = (byte) (prefix >> 8);
        out[i] = (byte) prefix;
    }
    //CSON: Magic

    @Override
    public void writeTo(final NativeMemory2 out, final int offset) {
        out.setLongUnaligned(prefix, offset);
    }

    @Override
    public void writeTo(final long out) {
        NativeMemory2.unboxedSetLong(out, prefix);
    }

    @Override
    public int expectedStringLength() {
        return LONG_STRING_LENGTH;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(prefix);
    }
}

