package ru.yandex.search.prefix;

import java.text.ParseException;

public enum PrefixType implements PrefixParser {
    LONG {
        @Override
        public Prefix parse(final String prefix) throws ParseException {
            try {
                return new LongPrefix(Long.parseLong(prefix));
            } catch (NumberFormatException e) {
                ParseException ex = new ParseException(
                    "Can't parse prefix " + prefix, 0);
                ex.initCause(e);
                throw ex;
            }
        }

        @Override
        public Prefix parse(final Object prefix) throws ParseException {
            if (prefix instanceof Long) {
                return new LongPrefix((Long) prefix);
            } else if (prefix instanceof String) {
                return parse((String) prefix);
            }
            throw new ParseException("Don't know how to parse " + prefix, 0);
        }
    },
    STRING {
        @Override
        public Prefix parse(final String prefix) throws ParseException {
            return parse((Object) prefix);
        }

        @Override
        public Prefix parse(final Object prefix) throws ParseException {
            if (prefix != null) {
                return new StringPrefix(prefix.toString());
            }
            throw new ParseException("Don't know how to parse null prefix", 0);
        }
    };
}

