package ru.yandex.search.prefix;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.unsafe.NativeMemory2;
import ru.yandex.util.unicode.UnicodeUtil;

public class StringPrefix implements Prefix {
    private static final long LONG_MASK = 0xffffffffL;

    private final String prefix;

    public StringPrefix(final String prefix) {
        this.prefix = prefix;
    }

    public String prefix() {
        return prefix;
    }

    @Override
    public PrefixType type() {
        return PrefixType.STRING;
    }

    @Override
    public long hash() {
        return prefix.hashCode() & LONG_MASK;
    }

    @Override
    public int hashCode() {
        return prefix.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return o == this
            || ((o instanceof StringPrefix)
                && prefix.equals(((StringPrefix) o).prefix));
    }

    @Override
    public String toString() {
        return prefix;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(prefix);
    }

    @Override
    public int sizeInBytes() {
        return UnicodeUtil.utf8Length(prefix);
    }

    @Override
    public void writeTo(final byte[] out, final int offset) {
        UnicodeUtil.toUtf8(prefix, out, offset);
    }

    @Override
    public void writeTo(final NativeMemory2 out, final int offset) {
        UnicodeUtil.toUtf8(prefix, out, offset);
    }

    @Override
    public void writeTo(final long out) {
        UnicodeUtil.toUtf8(prefix, out);
    }

    @Override
    public int expectedStringLength() {
        return prefix.length();
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(prefix);
    }
}

