package ru.yandex.search.proxy;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigBuilder;
import ru.yandex.search.mop.manager.config.MopManagerConfig;
import ru.yandex.search.mop.manager.config.MopManagerConfigBuilder;

public abstract class AbstractSearchProxyConfigBuilder
    <T extends AbstractSearchProxyConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements SearchProxyConfig
{
    private SearchMapConfigBuilder searchMapConfig;
    private HttpTargetConfigBuilder searchConfig;
    private HttpTargetConfigBuilder indexerConfig;
    private UpstreamsConfigBuilder upstreamsConfig;
    private MopManagerConfigBuilder mopManagerConfig;

    protected AbstractSearchProxyConfigBuilder(final SearchProxyConfig config) {
        super(config);
        if (config.searchMapConfig() != null) {
            searchMapConfig = new SearchMapConfigBuilder(config.searchMapConfig());
        } else {
            searchMapConfig = null;
        }
        searchConfig = new HttpTargetConfigBuilder(config.searchConfig());
        indexerConfig = new HttpTargetConfigBuilder(config.indexerConfig());
        upstreamsConfig = new UpstreamsConfigBuilder(config.upstreamsConfig());
        if (config.mopManagerConfig() == null) {
            mopManagerConfig = null;
        } else {
            mopManagerConfig =
                new MopManagerConfigBuilder(config.mopManagerConfig());
        }
    }

    protected AbstractSearchProxyConfigBuilder(
        final IniConfig config,
        final SearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig searchMapSection = config.section("searchmap");
        if (searchMapSection != null) {
            searchMapConfig = new SearchMapConfigBuilder(
                    searchMapSection,
                    defaults.searchMapConfig());
        } else {
            searchMapConfig = null;
        }
        IniConfig searchSection = config.section(SEARCH_SECTION);
        searchConfig = new HttpTargetConfigBuilder(
            searchSection,
            defaults.searchConfig());
        indexerConfig = new HttpTargetConfigBuilder(
            config.section(INDEXER_SECTION),
            defaults.indexerConfig());
        upstreamsConfig = new UpstreamsConfigBuilder(
            config.section(UpstreamsConfigBuilder.SECTION),
            new UpstreamsConfigBuilder(
                searchSection,
                defaults.upstreamsConfig()));
        IniConfig mopSection = config.sectionOrNull(MOP_SECTION);
        if (mopSection == null) {
            mopManagerConfig = null;
        } else {
            mopManagerConfig = new MopManagerConfigBuilder(mopSection);
        }
    }

    @Override
    public SearchMapConfigBuilder searchMapConfig() {
        return searchMapConfig;
    }

    public T searchMapConfig(final SearchMapConfig searchMapConfig) {
        if (searchMapConfig != null) {
            this.searchMapConfig = new SearchMapConfigBuilder(searchMapConfig);
        } else {
            this.searchMapConfig = null;
        }
        return self();
    }

    @Override
    public HttpTargetConfigBuilder searchConfig() {
        return searchConfig;
    }

    public T searchConfig(final HttpTargetConfig searchConfig) {
        this.searchConfig = new HttpTargetConfigBuilder(searchConfig);
        return self();
    }

    @Override
    public HttpTargetConfigBuilder indexerConfig() {
        return indexerConfig;
    }

    public T indexerConfig(final HttpTargetConfig indexerConfig) {
        this.indexerConfig = new HttpTargetConfigBuilder(indexerConfig);
        return self();
    }

    @Override
    public UpstreamsConfigBuilder upstreamsConfig() {
        return upstreamsConfig;
    }

    public T upstreamsConfig(final UpstreamsConfig upstreamsConfig) {
        this.upstreamsConfig = new UpstreamsConfigBuilder(upstreamsConfig);
        return self();
    }

    @Override
    public MopManagerConfigBuilder mopManagerConfig() {
        return mopManagerConfig;
    }

    public T mopManagerConfig(final MopManagerConfig mopManagerConfig) {
        if (mopManagerConfig == null) {
            this.mopManagerConfig = null;
        } else {
            this.mopManagerConfig = new MopManagerConfigBuilder(mopManagerConfig);
        }
        return self();
    }
}

