package ru.yandex.search.proxy;

import ru.yandex.http.config.AbstractHttpTargetConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.request.config.SearchBackendRequestConfig;
import ru.yandex.search.request.config.SearchBackendRequestConfigBuilder;

public abstract class AbstractUpstreamConfigBuilder
    <T extends AbstractUpstreamConfigBuilder<T>>
    extends AbstractHttpTargetConfigBuilder<T>
    implements UpstreamConfig
{
    private String removePrefix;
    private SearchBackendRequestConfigBuilder requestConfig;

    protected AbstractUpstreamConfigBuilder(final UpstreamConfig config) {
        super(config);
        removePrefix = config.removePrefix();
        requestConfig(config.requestConfig());
    }

    protected AbstractUpstreamConfigBuilder(
        final IniConfig config,
        final UpstreamConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        removePrefix = config.getString(
            "remove-prefix",
            defaults.removePrefix());
        requestConfig =
            new SearchBackendRequestConfigBuilder(
                config,
                defaults.requestConfig());
    }

    @Override
    public String removePrefix() {
        return removePrefix;
    }

    public T removePrefix(final String removePrefix) {
        this.removePrefix = removePrefix;
        return self();
    }


    public void copyTo(final AbstractUpstreamConfigBuilder<?> other) {
        copyTo((AbstractHttpTargetConfigBuilder<?>) other);
        other.removePrefix(removePrefix());
        other.requestConfig(requestConfig());
    }

    @Override
    public SearchBackendRequestConfigBuilder requestConfig() {
        return requestConfig;
    }

    public T requestConfig(
        final SearchBackendRequestConfig requestConfig)
    {
        this.requestConfig = new SearchBackendRequestConfigBuilder(requestConfig);
        return self();
    }
}
