package ru.yandex.search.proxy;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

public class BroadcastCallback
    extends AbstractProxySessionCallback<List<Map.Entry<HttpHost, String>>>
{
    public BroadcastCallback(final ProxySession session) {
        super(session);
    }

    @Override
    public void completed(final List<Map.Entry<HttpHost, String>> responses) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<HttpHost, String> entry: responses) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append('\n');
            sb.append(entry.getValue());
            sb.append('\n');
            sb.append('\n');
        }
        session.response(HttpStatus.SC_OK, new String(sb));
    }
}

