package ru.yandex.search.proxy;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;
import ru.yandex.search.mop.manager.config.ImmutableMopManagerConfig;

public class ImmutableSearchProxyConfig
    extends ImmutableHttpProxyConfig
    implements SearchProxyConfig
{
    private final ImmutableSearchMapConfig searchMapConfig;
    private final ImmutableHttpTargetConfig searchConfig;
    private final ImmutableHttpTargetConfig indexerConfig;
    private final ImmutableUpstreamsConfig upstreamsConfig;
    private final ImmutableMopManagerConfig mopManagerConfig;

    public ImmutableSearchProxyConfig(final SearchProxyConfig config)
        throws ConfigException
    {
        super(config);
        if (config.searchMapConfig() != null) {
            searchMapConfig =
                    new ImmutableSearchMapConfig(config.searchMapConfig());
        } else {
            searchMapConfig = null;
        }
        searchConfig = new ImmutableHttpTargetConfig(config.searchConfig());
        indexerConfig = new ImmutableHttpTargetConfig(config.indexerConfig());
        upstreamsConfig =
            new ImmutableUpstreamsConfig(config.upstreamsConfig());
        if (config.mopManagerConfig() == null) {
            mopManagerConfig = null;
        } else {
            mopManagerConfig =
                new ImmutableMopManagerConfig(config.mopManagerConfig());
        }
    }

    @Override
    public ImmutableSearchMapConfig searchMapConfig() {
        return searchMapConfig;
    }

    @Override
    public ImmutableHttpTargetConfig searchConfig() {
        return searchConfig;
    }

    @Override
    public ImmutableHttpTargetConfig indexerConfig() {
        return indexerConfig;
    }

    @Override
    public ImmutableUpstreamsConfig upstreamsConfig() {
        return upstreamsConfig;
    }

    @Override
    public ImmutableMopManagerConfig mopManagerConfig() {
        return mopManagerConfig;
    }
}

