package ru.yandex.search.proxy;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.request.config.ImmutableSearchBackendRequestConfig;

public class ImmutableUpstreamConfig
    extends ImmutableHttpTargetConfig
    implements UpstreamConfig
{
    private final String removePrefix;
    private final ImmutableSearchBackendRequestConfig requestConfig;

    public ImmutableUpstreamConfig(final UpstreamConfig config)
        throws ConfigException
    {
        super(config);
        removePrefix = config.removePrefix();
        requestConfig = new ImmutableSearchBackendRequestConfig(config.requestConfig());
    }

    @Override
    public String removePrefix() {
        return removePrefix;
    }

    @Override
    public ImmutableSearchBackendRequestConfig requestConfig() {
        return requestConfig;
    }
}
