package ru.yandex.search.proxy;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericBiFunction;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncClientRegistrar;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableUpstreamsConfig implements UpstreamsConfig {
    private static final GenericFunction<
        UpstreamConfig,
        ImmutableUpstreamConfig,
        ConfigException> TRANSFORMER =
        new GenericFunction<
            UpstreamConfig,
            ImmutableUpstreamConfig,
            ConfigException>()
        {
            @Override
            public ImmutableUpstreamConfig apply(final UpstreamConfig config)
                throws ConfigException
            {
                if (config == null) {
                    return null;
                } else {
                    return new ImmutableUpstreamConfig(config);
                }
            }
        };

    private final PatternMap<RequestInfo, ImmutableUpstreamConfig>
        upstreamsConfigs;

    public ImmutableUpstreamsConfig(final UpstreamsConfig config)
        throws ConfigException
    {
        upstreamsConfigs = config.upstreams().transform(TRANSFORMER);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableUpstreamConfig> upstreams() {
        return upstreamsConfigs;
    }

    public PatternMap<RequestInfo, UpstreamContext> prepareClients(
        final AsyncClientRegistrar asyncClientRegistrar)
    {
        return upstreamsConfigs.transform(
            new ClientTransformer(asyncClientRegistrar));
    }

    private static class ClientTransformer
        implements GenericBiFunction<
            Pattern<RequestInfo>,
            ImmutableUpstreamConfig,
            UpstreamContext,
            RuntimeException>
    {
        private final AsyncClientRegistrar asyncClientRegistrar;

        ClientTransformer(final AsyncClientRegistrar asyncClientRegistrar) {
            this.asyncClientRegistrar = asyncClientRegistrar;
        }

        @Override
        public UpstreamContext apply(
            final Pattern<RequestInfo> pattern,
            final ImmutableUpstreamConfig config)
        {
            if (config == null) {
                return null;
            } else {
                return new UpstreamContext(
                    config,
                    asyncClientRegistrar.registerClient(
                        "upstream-client-" + pattern,
                        new AsyncClient(
                            asyncClientRegistrar.reactor(),
                            config),
                        config));
            }
        }
    }
}

