package ru.yandex.search.proxy;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.searchmap.PrefixInfo;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.ScanningCgiParams;
import ru.yandex.search.prefix.Prefix;

public class PrefixInfoHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final SearchMap searchMap;

    public PrefixInfoHandler(final SearchMap searchMap) {
        this.searchMap = searchMap;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        ScanningCgiParams params = new ScanningCgiParams(request);
        String service = params.get("service", NonEmptyValidator.INSTANCE);
        Prefix prefix = params.get("prefix", searchMap.prefixType(service));
        JsonType jsonType = JsonTypeExtractor.NULL.extract(params);
        PrefixInfo info = searchMap.prefixInfo(new User(service, prefix));
        exchange.getResponse().setEntity(createEntity(info, jsonType));
        exchange.submitResponse();
    }

    @Override
    public String toString() {
        return "Print information about prefix and associated hosts using "
            + "'?prefix=' and '&service=' params";
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    private NStringEntity createEntity(
        final PrefixInfo info,
        final JsonType jsonType)
        throws IOException
    {
        if (jsonType == null) {
            return new NStringEntity(info.toString(), ContentType.TEXT_PLAIN);
        }
        StringBuilderWriter writer = new StringBuilderWriter();
        try (JsonWriter out = jsonType.create(writer)) {
            out.value(info.toMap());
        }
        return new NStringEntity(
            writer.toString(),
            ContentType.APPLICATION_JSON);
    }
}

