package ru.yandex.search.proxy;

import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.parser.searchmap.SearchMap;

public class SearchMapReloader
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final SearchMap searchMap;

    public SearchMapReloader(final SearchMap searchMap) {
        this.searchMap = searchMap;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        Logger sessionLogger =
            (Logger) context.getAttribute(HttpServer.LOGGER);
        try {
            searchMap.reload();
        } catch (IOException | ParseException e) {
            sessionLogger.log(Level.WARNING, "Searchmap reload failed", e);
            throw new ServiceUnavailableException(e);
        }
        sessionLogger.info("Searchmap reload completed");
        exchange.getResponse().setEntity(
            new NStringEntity("Searchmap reloaded", ContentType.TEXT_PLAIN));
        exchange.submitResponse();
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public String toString() {
        return "Reloads searchmap from file";
    }
}

