package ru.yandex.search.proxy;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class SearchProxyConfigBuilder
    extends AbstractSearchProxyConfigBuilder<SearchProxyConfigBuilder>
{
    public SearchProxyConfigBuilder() {
        super(SearchProxyConfigDefaults.INSTANCE);
    }

    public SearchProxyConfigBuilder(final SearchProxyConfig config) {
        super(config);
    }

    public SearchProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, SearchProxyConfigDefaults.INSTANCE);
    }

    public SearchProxyConfigBuilder(
        final IniConfig config,
        final SearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SearchProxyConfigBuilder self() {
        return this;
    }

    public ImmutableSearchProxyConfig build() throws ConfigException {
        return new ImmutableSearchProxyConfig(this);
    }
}

