package ru.yandex.search.proxy;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.logger.LoggersConfig;
import ru.yandex.logger.SearchProxyLoggersConfigDefaults;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigDefaults;
import ru.yandex.search.mop.manager.config.MopManagerConfig;

public class SearchProxyConfigDefaults
    extends HttpProxyConfigDefaults
    implements SearchProxyConfig
{
    public static final SearchProxyConfigDefaults INSTANCE =
        new SearchProxyConfigDefaults();

    protected SearchProxyConfigDefaults() {
    }

    @Override
    public LoggersConfig loggers() {
        return SearchProxyLoggersConfigDefaults.INSTANCE;
    }

    @Override
    public SearchMapConfig searchMapConfig() {
        return SearchMapConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig searchConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig indexerConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public UpstreamsConfig upstreamsConfig() {
        return UpstreamsConfigDefaults.INSTANCE;
    }

    @Override
    public MopManagerConfig mopManagerConfig() {
        return null;
    }
}

