package ru.yandex.search.proxy;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.json.async.consumer.JsonAsyncConsumer;
import ru.yandex.json.parser.KeyInterningStringCollectorsFactory;
import ru.yandex.search.result.BasicSearchResult;
import ru.yandex.search.result.SearchResult;
import ru.yandex.search.result.SearchResultHandler;

public class SearchResultConsumer extends JsonAsyncConsumer<SearchResult> {
    private final SearchResult result;

    public SearchResultConsumer(
            final HttpHost target,
            final HttpEntity entity,
            final HttpResponse response)
        throws HttpException
    {
        this(entity, new BasicSearchResult(target), response);
    }

    private SearchResultConsumer(
        final HttpEntity entity,
        final BasicSearchResult result,
        final HttpResponse response)
        throws HttpException
    {
        super(
            entity,
            new SearchResultHandler(result, getZooQueueId(response)),
            KeyInterningStringCollectorsFactory.INSTANCE);
        this.result = result;
    }

    @Override
    protected SearchResult doBuildResult(final HttpContext context) {
        return result;
    }

    private static long getZooQueueId(final HttpResponse response) {
        long zooQueueId = SearchResult.DEFAULT_QUEUE_ID;
        Header zooQueueIdHeader =
            response.getFirstHeader(YandexHeaders.ZOO_QUEUE_ID);
        if (zooQueueIdHeader != null) {
            zooQueueId = Long.parseLong(zooQueueIdHeader.getValue());
        }
        return zooQueueId;
    }
}

