package ru.yandex.search.proxy;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.search.result.SearchResult;

public enum SearchResultConsumerFactory
    implements HttpAsyncResponseConsumerFactory<SearchResult>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<SearchResult>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public SearchResultConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new SearchResultConsumer(
            producer.getTarget(),
            response.getEntity(),
            response);
    }
}

