package ru.yandex.search.proxy;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;

public class UnicastCallback
    extends AbstractProxySessionCallback<HttpResponse>
{
    public UnicastCallback(final ProxySession session) {
        super(session);
    }

    @Override
    public void completed(final HttpResponse response) {
        HttpEntity entity = response.getEntity();
        try {
            byte[] buf = CharsetUtils.toDecodable(entity).toByteArray();
            HttpResponse nextResponse =
                new BasicHttpResponse(response.getStatusLine());
            NByteArrayEntity nextEntity = new NByteArrayEntity(buf);
            nextEntity.setContentEncoding(entity.getContentEncoding());
            nextEntity.setContentType(entity.getContentType());
            nextResponse.setEntity(nextEntity);
            session.response(nextResponse);
        } catch (IOException e) {
            failed(new HttpException("Failed to read data", e));
        }
    }
}

