package ru.yandex.search.proxy;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class UpstreamConfigBuilder
    extends AbstractUpstreamConfigBuilder<UpstreamConfigBuilder>
{
    public UpstreamConfigBuilder() {
        super(UpstreamConfigDefaults.INSTANCE);
    }

    public UpstreamConfigBuilder(final UpstreamConfig config) {
        super(config);
    }

    public UpstreamConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        super(config, UpstreamConfigDefaults.INSTANCE);
    }

    public UpstreamConfigBuilder(
        final IniConfig config,
        final UpstreamConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public UpstreamConfigBuilder self() {
        return this;
    }

    public ImmutableUpstreamConfig build() throws ConfigException {
        return new ImmutableUpstreamConfig(this);
    }
}
