package ru.yandex.search.proxy;

import ru.yandex.http.util.nio.client.AsyncClient;

public class UpstreamContext {
    private final ImmutableUpstreamConfig config;
    private final AsyncClient client;

    public UpstreamContext(
        final ImmutableUpstreamConfig config,
        final AsyncClient client)
    {
        this.config = config;
        this.client = client;
    }

    public ImmutableUpstreamConfig config() {
        return config;
    }

    public AsyncClient client() {
        return client;
    }

    // CSOFF: FinalParameters
    public String removePrefix(String uri) {
        uri = uri.substring(uri.indexOf('/', 1));
        String removePrefix = config.removePrefix();
        if (!removePrefix.isEmpty() && uri.startsWith(removePrefix)) {
            uri = uri.substring(removePrefix.length());
        }
        return uri;
    }
    // CSON: FinalParameters
}

