package ru.yandex.search.request;

import java.util.Locale;

import ru.yandex.search.request.util.QueryAppender;

public enum QueryOperator implements QueryAppender {
    OR,
    AND;

    private final String queryValue;

    QueryOperator() {
        queryValue = " " + name().toUpperCase(Locale.ENGLISH) + " ";
    }

    public String queryValue() {
        return queryValue;
    }

    @Override
    public void appendTo(final StringBuilder sb) {
        sb.append(queryValue);
    }
}
