package ru.yandex.search.request.config;

import ru.yandex.parser.string.ValuesStorage;
import ru.yandex.search.request.SearchBackendRequestType;

public abstract class AbstractSearchBackendRequestConfigBuilder
    <T extends AbstractSearchBackendRequestConfigBuilder<T>>
     implements SearchBackendRequestConfig
{
    private SearchBackendRequestType type;
    private long failoverDelay;
    private Long minPos;
    private boolean allowLaggingHosts;
    private boolean localityShuffle;

    protected AbstractSearchBackendRequestConfigBuilder(
        final SearchBackendRequestConfig config)
    {
        type(config.type());
        failoverDelay(config.failoverDelay());
        minPos(config.minPos());
        allowLaggingHosts(config.allowLaggingHosts());
        localityShuffle(config.localityShuffle());
    }

    protected <E extends Exception> AbstractSearchBackendRequestConfigBuilder(
        final ValuesStorage<E> config,
        final SearchBackendRequestConfig defaults)
        throws E
    {
        this.type = config.getEnum(SearchBackendRequestType.class, "type", defaults.type());
        this.failoverDelay =
            config.getLongDuration("failover-delay", defaults.failoverDelay());
        this.minPos = config.getLong("min-pos", defaults.minPos());
        this.allowLaggingHosts =
            config.getBoolean(
                "allow-lagging-hosts",
                defaults.allowLaggingHosts());
        this.localityShuffle =
            config.getBoolean("locality-shuffle", defaults.localityShuffle());
    }

    @Override()
    public SearchBackendRequestType type() {
        return type;
    }

    public T type(final SearchBackendRequestType value) {
        this.type = value;
        return self();
    }

    @Override()
    public long failoverDelay() {
        return failoverDelay;
    }

    public T failoverDelay(final long value) {
        this.failoverDelay = value;
        return self();
    }

    @Override()
    public Long minPos() {
        return minPos;
    }

    public T minPos(final Long value) {
        this.minPos = value;
        return self();
    }

    @Override()
    public boolean allowLaggingHosts() {
        return allowLaggingHosts;
    }

    public T allowLaggingHosts(final boolean value) {
        this.allowLaggingHosts = value;
        return self();
    }

    @Override()
    public boolean localityShuffle() {
        return localityShuffle;
    }

    public T localityShuffle(final boolean value) {
        this.localityShuffle = value;
        return self();
    }

    protected abstract T self();
}
