package ru.yandex.search.request.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.request.SearchBackendRequestType;

public class ImmutableSearchBackendRequestConfig
     implements SearchBackendRequestConfig
{
    private final SearchBackendRequestType type;
    private final long failoverDelay;
    private final Long minPos;
    private final boolean allowLaggingHosts;
    private final boolean localityShuffle;

    public ImmutableSearchBackendRequestConfig(
        final SearchBackendRequestConfig config)
        throws ConfigException
    {
        this.type = config.type();
        this.failoverDelay = config.failoverDelay();
        this.minPos = config.minPos();
        this.allowLaggingHosts = config.allowLaggingHosts();
        this.localityShuffle = config.localityShuffle();
    }

    @Override
    public SearchBackendRequestType type() {
        return type;
    }

    @Override
    public long failoverDelay() {
        return failoverDelay;
    }

    @Override
    public Long minPos() {
        return minPos;
    }

    @Override
    public boolean allowLaggingHosts() {
        return allowLaggingHosts;
    }

    @Override
    public boolean localityShuffle() {
        return localityShuffle;
    }
}
