package ru.yandex.search.request.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;

public class ImmutableSearchBackendRequestTagsConfig implements SearchBackendRequestTagsConfig {
    private final Map<String, ImmutableSearchBackendRequestConfig> map;
    private final ImmutableSearchBackendRequestConfig asterisk;

    public ImmutableSearchBackendRequestTagsConfig(
        final SearchBackendRequestTagsConfig config)
        throws ConfigException
    {
        Map<String, ImmutableSearchBackendRequestConfig> map = new LinkedHashMap<>(config.map().size());
        for (Map.Entry<String, ? extends SearchBackendRequestConfig> entry: config.map().entrySet()) {
            map.put(entry.getKey(), new ImmutableSearchBackendRequestConfig(entry.getValue()));
        }

        this.map = Collections.unmodifiableMap(map);
        this.asterisk = new ImmutableSearchBackendRequestConfig(config.asterisk());
    }

    @Override
    public Map<String, ImmutableSearchBackendRequestConfig> map() {
        return map;
    }

    @Override
    public ImmutableSearchBackendRequestConfig asterisk() {
        return asterisk;
    }

    @Override
    public ImmutableSearchBackendRequestConfig get(final String tag) {
        return map.getOrDefault(tag, asterisk);
    }
}
