package ru.yandex.search.request.config;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSearchBackendRequestsConfig implements SearchBackendRequestsConfig {
    private final PatternMap<RequestInfo, ImmutableSearchBackendRequestTagsConfig> configs;

    public ImmutableSearchBackendRequestsConfig(
        final SearchBackendRequestsConfig config)
        throws ConfigException
    {
        configs = config
            .configs()
            .transform(
                ImmutableSearchBackendRequestTagsConfig::new);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableSearchBackendRequestTagsConfig> configs() {
        return configs;
    }
}
