package ru.yandex.search.request.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.ValuesStorage;

public class SearchBackendRequestConfigBuilder
     extends AbstractSearchBackendRequestConfigBuilder<SearchBackendRequestConfigBuilder>
{
    public SearchBackendRequestConfigBuilder() {
        this(SearchBackendRequestConfigDefaults.INSTANCE);
    }

    public SearchBackendRequestConfigBuilder(final SearchBackendRequestConfig config) {
        super(config);
    }

    public SearchBackendRequestConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, SearchBackendRequestConfigDefaults.INSTANCE);
    }

    public <E extends Exception> SearchBackendRequestConfigBuilder(
        final ValuesStorage<E> storage,
        final SearchBackendRequestConfig defaults)
        throws E
    {
        super(storage, defaults);
    }

    public ImmutableSearchBackendRequestConfig build() throws ConfigException {
        return new ImmutableSearchBackendRequestConfig(this);
    }

    @Override
    protected SearchBackendRequestConfigBuilder self() {
        return this;
    }
}
