package ru.yandex.search.request.config;

import ru.yandex.search.request.SearchBackendRequestType;

public class SearchBackendRequestConfigDefaults
     implements SearchBackendRequestConfig
{
    public static final SearchBackendRequestConfigDefaults INSTANCE =
        new SearchBackendRequestConfigDefaults();

    private static final long DEFAULT_FAILOVER_DELAY = 100;

    protected SearchBackendRequestConfigDefaults() {
    }

    @Override
    public SearchBackendRequestType type() {
        return SearchBackendRequestType.SEQUENTIAL;
    }

    @Override
    public long failoverDelay() {
        return DEFAULT_FAILOVER_DELAY;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public boolean allowLaggingHosts() {
        return false;
    }

    @Override
    public boolean localityShuffle() {
        return true;
    }
}
