package ru.yandex.search.request.config;

import java.util.LinkedHashMap;
import java.util.Map;

public class SearchBackendRequestTagsConfigBuilder implements SearchBackendRequestTagsConfig {
    private Map<String, SearchBackendRequestConfigBuilder> map;
    private SearchBackendRequestConfigBuilder asterisk;

    public SearchBackendRequestTagsConfigBuilder(
        final Map<String, SearchBackendRequestConfigBuilder> map,
        final SearchBackendRequestConfigBuilder asterisk)
    {
        this.map = map;
        this.asterisk = asterisk;
    }

    public SearchBackendRequestTagsConfigBuilder(final SearchBackendRequestTagsConfig config) {
        this.map(config.map());
        this.asterisk(config.asterisk());
    }

    @Override
    public Map<String, SearchBackendRequestConfigBuilder> map() {
        return map;
    }

    @Override
    public SearchBackendRequestConfig asterisk() {
        return asterisk;
    }

    @Override
    public SearchBackendRequestConfigBuilder get(final String tag) {
        return map.getOrDefault(tag, asterisk);
    }

    public SearchBackendRequestTagsConfigBuilder map(
        final Map<String, ? extends SearchBackendRequestConfig> map)
    {
        this.map = new LinkedHashMap<>();
        for (Map.Entry<String, ? extends SearchBackendRequestConfig> entry: map.entrySet()) {
            this.map.put(entry.getKey(), new SearchBackendRequestConfigBuilder(entry.getValue()));
        }
        return this;
    }

    public SearchBackendRequestTagsConfigBuilder asterisk(
        final SearchBackendRequestConfig asterisk)
    {
        this.asterisk = new SearchBackendRequestConfigBuilder(asterisk);
        return this;
    }

    @Override
    public String toString() {
        return "SearchBackendRequestTagsConfigBuilder{" +
            "map=" + map +
            ", asterisk=" + asterisk +
            '}';
    }
}
