package ru.yandex.search.request.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.collection.PatternStringPredicate;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SearchBackendRequestsConfigBuilder implements SearchBackendRequestsConfig {
    private PatternMap<RequestInfo, SearchBackendRequestTagsConfigBuilder> configs;

    public SearchBackendRequestsConfigBuilder(
        final SearchBackendRequestsConfig config)
    {
        this.configs(config.configs());
    }

    public SearchBackendRequestsConfigBuilder(final IniConfig config) throws ConfigException {
        this(config, SearchBackendRequestsConfigDefaults.INSTANCE);
    }

    public SearchBackendRequestsConfigBuilder(
        final IniConfig config,
        final SearchBackendRequestsConfig defaults)
        throws ConfigException
    {
        IniConfig requestSection = config.sectionOrNull("request");
        if (requestSection != null) {
            // for asterisk we support only default tag now
            SearchBackendRequestConfigBuilder asterisk =
                new SearchBackendRequestConfigBuilder(
                    requestSection,
                    defaults.configs().asterisk().asterisk());

            //System.out.println("Asterisk section " + asterisk.toStringCustom());
            configs = new PatternMap<>(
                new SearchBackendRequestTagsConfigBuilder(Collections.emptyMap(), asterisk));

            for (Map.Entry<String, IniConfig> entry : requestSection.sections().entrySet()) {
                String subsection = entry.getKey();
                Pattern<RequestInfo> pattern;

                if (PatternStringPredicate.INSTANCE.test(subsection)) {
                    IniConfig tags = entry.getValue();
                    pattern = RequestPatternParser.INSTANCE.apply(subsection);

                    SearchBackendRequestTagsConfig defaultForPredicate
                        = defaults.configs().get(pattern);

                    SearchBackendRequestConfigBuilder defaultConfig =
                        new SearchBackendRequestConfigBuilder(
                            tags,
                            defaultForPredicate.asterisk());

                    Map<String, SearchBackendRequestConfigBuilder> map = new LinkedHashMap<>();
                    for (Map.Entry<String, IniConfig> tagEntry: tags.sections().entrySet()) {
                        SearchBackendRequestConfigBuilder requestConfig =
                            new SearchBackendRequestConfigBuilder(
                                tagEntry.getValue(),
                                defaultForPredicate.get(tagEntry.getKey()));
                        map.put(tagEntry.getKey(), requestConfig);
                    }

                    configs.put(
                        pattern,
                        new SearchBackendRequestTagsConfigBuilder(map, defaultConfig));
                }
            }
        } else {
            configs(defaults.configs());
        }
    }

    @Override
    public PatternMap<RequestInfo, SearchBackendRequestTagsConfigBuilder> configs() {
        return configs;
    }

    public SearchBackendRequestsConfigBuilder configs(
        final PatternMap<RequestInfo, ? extends SearchBackendRequestTagsConfig> configs)
    {
        this.configs = configs.transform(
            (config) -> new SearchBackendRequestTagsConfigBuilder(config));
        return this;
    }

}
