package ru.yandex.search.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;

public class BasicSearchDocument implements SearchDocument {
    private final Map<String, String> attrs;
    private final List<SearchDocument> mergedDocs;

    public BasicSearchDocument() {
        this(new HashMap<String, String>(), new ArrayList<SearchDocument>());
    }

    public BasicSearchDocument(
        final Map<String, String> attrs,
        final List<SearchDocument> mergedDocs)
    {
        this.attrs = attrs;
        this.mergedDocs = mergedDocs;
    }

    @Override
    public Map<String, String> attrs() {
        return attrs;
    }

    @Override
    public List<SearchDocument> mergedDocs() {
        return mergedDocs;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        for (Map.Entry<String, String> entry: attrs.entrySet()) {
            writer.key(entry.getKey());
            writer.value(entry.getValue());
        }
        if (!mergedDocs.isEmpty()) {
            writer.key("merged_docs");
            writer.startArray();
            for (SearchDocument document: mergedDocs) {
                document.writeValue(writer);
            }
            writer.endArray();
        }
        writer.endObject();
    }

    @Override
    public int hashCode() {
        return attrs.hashCode() ^ mergedDocs.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof SearchDocument) {
            SearchDocument other = (SearchDocument) o;
            return attrs.equals(other.attrs())
                && mergedDocs.equals(other.mergedDocs());
        }
        return false;
    }
}

