package ru.yandex.search.result;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpHost;

public class BasicSearchResult implements SearchResult {
    private final HttpHost host;
    private final List<SearchDocument> hitsArray;
    private long hitsCount;
    private long zooQueueId;

    public BasicSearchResult() {
        this(new ArrayList<SearchDocument>(), 0);
    }

    public BasicSearchResult(final HttpHost host) {
        this.host = host;
        this.hitsArray = new ArrayList<>();
        this.hitsCount = 0;
    }

    public BasicSearchResult(
        final List<SearchDocument> hitsArray,
        final long hitsCount)
    {
        this.host = null;
        this.hitsCount = hitsCount;
        this.hitsArray = hitsArray;
    }

    @Override
    public HttpHost host() {
        return host;
    }

    @Override
    public long hitsCount() {
        return hitsCount;
    }

    public void hitsCount(final long hitsCount) {
        this.hitsCount = hitsCount;
    }

    @Override
    public long zooQueueId() {
        return zooQueueId;
    }

    public void zooQueueId(final long zooQueueId) {
        this.zooQueueId = zooQueueId;
    }

    @Override
    public List<SearchDocument> hitsArray() {
        return hitsArray;
    }

    public SearchDocument hit(final int i) {
        while (i >= hitsArray.size()) {
            hitsArray.add(createSearchDocument());
        }
        return hitsArray.get(i);
    }

    public SearchDocument mergedDoc(final int hit, final int i) {
        List<SearchDocument> mergedDocs = hit(hit).mergedDocs();
        while (i >= mergedDocs.size()) {
            mergedDocs.add(createSearchDocument());
        }
        return mergedDocs.get(i);
    }

    protected SearchDocument createSearchDocument() {
        return new BasicSearchDocument();
    }
}

