package ru.yandex.search.result;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;

public class FilterSearchDocument implements SearchDocument {
    protected final SearchDocument document;

    public FilterSearchDocument(final SearchDocument document) {
        this.document = document;
    }

    @Override
    public Map<String, String> attrs() {
        return document.attrs();
    }

    @Override
    public List<SearchDocument> mergedDocs() {
        return document.mergedDocs();
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        document.writeValue(writer);
    }

    @Override
    public int hashCode() {
        return document.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return document.equals(o);
    }
}

