package ru.yandex.search.result;

import java.util.Collections;
import java.util.List;

import org.apache.http.HttpHost;

public interface SearchResult {
    long DEFAULT_QUEUE_ID = Integer.MIN_VALUE;

    SearchResult EMPTY = new SearchResult() {
        @Override
        public long hitsCount() {
            return 0L;
        }

        @Override
        public List<SearchDocument> hitsArray() {
            return Collections.emptyList();
        }

        @Override
        public long zooQueueId() {
            return DEFAULT_QUEUE_ID;
        }

        @Override
        public HttpHost host() {
            return null;
        }
    };

    HttpHost host();

    long hitsCount();

    List<SearchDocument> hitsArray();

    long zooQueueId();
}

