package ru.yandex.search.result;

import java.util.List;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;
import ru.yandex.json.xpath.ValueUtils;

public class SearchResultHandler implements PrimitiveHandler {
    private static final int VALUE_DEPTH = 3;
    private static final int MERGED_VALUE_DEPTH = 5;
    private static final String HITS_ARRAY = "hitsArray";
    private static final String MERGED_DOCS = "merged_docs";
    private static final int HIT_INDEX = 1;
    private static final int MERGED_DOC_INDEX = 3;

    private final BasicSearchResult result;
    private final boolean allowNulls;

    public SearchResultHandler(final BasicSearchResult result) {
        this(result, false, SearchResult.DEFAULT_QUEUE_ID);
    }

    public SearchResultHandler(
            final BasicSearchResult result,
            final long zooQueueId)
    {
        this(result, false, zooQueueId);
    }

    public SearchResultHandler(
            final BasicSearchResult result,
            final boolean allowNulls)
    {
        this(result, allowNulls, SearchResult.DEFAULT_QUEUE_ID);
    }

    public SearchResultHandler(
        final BasicSearchResult result,
        final boolean allowNulls,
        final long zooQueueId)
    {
        this.result = result;
        this.allowNulls = allowNulls;
        this.result.zooQueueId(zooQueueId);
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonException
    {
        if (path.size() == 1 && value != null) {
            if ("hitsCount".equals(path.get(0).name())) {
                result.hitsCount(ValueUtils.asLong(value));
            }
            return;
        }
        if (value == null && !allowNulls) {
            return;
        }
        if (isValue(path)) {
            SearchDocument hit = result.hit(path.get(HIT_INDEX).index());
            hit.attrs().put(
                path.get(path.size() - 1).name(),
                ValueUtils.asStringOrNull(value));
        } else if (isMergedValue(path)) {
            SearchDocument mergedDoc =
                result.mergedDoc(
                    path.get(HIT_INDEX).index(),
                    path.get(MERGED_DOC_INDEX).index());
            mergedDoc.attrs().put(
                path.get(path.size() - 1).name(),
                ValueUtils.asStringOrNull(value));
        }
    }

    private boolean isValue(final List<PathComponent> path) {
        int comp = 0;
        return path.size() == VALUE_DEPTH
            && HITS_ARRAY.equals(path.get(comp++).name())
            && path.get(comp++).name() == null
            && path.get(comp++).name() != null;
    }

    private boolean isMergedValue(final List<PathComponent> path) {
        int comp = 0;
        return path.size() == MERGED_VALUE_DEPTH
            && HITS_ARRAY.equals(path.get(comp++).name())
            && path.get(comp++).name() == null
            && MERGED_DOCS.equals(path.get(comp++).name())
            && path.get(comp++).name() == null
            && path.get(comp++).name() != null;
    }
}

