package ru.yandex.search.rules;

import java.util.Set;

public class BasicRequestParams implements RequestParams {
    protected final int offset;
    protected final int length;
    protected final Set<String> fields;

    public BasicRequestParams(
        final int offset,
        final int length,
        final Set<String> fields)
    {
        this.offset = offset;
        this.length = length;
        this.fields = fields;
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public int length() {
        return length;
    }

    @Override
    public Set<String> fields() {
        return fields;
    }
}

