package ru.yandex.search.rules;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.CgiParams;

public class BasicSearchRequest<
    D,
    P extends RequestParams,
    I extends SearchInfo>
    implements SearchRequest<D, P, I>
{
    private final ProxySession session;
    private final P requestParams;
    private final I searchInfo;
    private final FutureCallback<? super D> callback;
    private final CgiParams cgiParams;

    public BasicSearchRequest(
        final ProxySession session,
        final SearchService<D, P, I> service)
        throws BadRequestException
    {
        this.session = session;
        requestParams = service.createRequestParams(session);
        searchInfo = service.createSearchInfo(session, requestParams);
        callback = service.createCallback(session, requestParams, searchInfo);
        cgiParams = session.params();
    }

    private BasicSearchRequest(
        final BasicSearchRequest<D, P, I> sample,
        final CgiParams cgiParams)
    {
        this.cgiParams = cgiParams;
        session = sample.session;
        requestParams = sample.requestParams;
        callback = sample.callback;
        searchInfo = sample.searchInfo;
    }

    private BasicSearchRequest(
        final BasicSearchRequest<D, P, I> sample,
        final FutureCallback<? super D> callback)
    {
        this.callback = callback;
        session = sample.session;
        requestParams = sample.requestParams;
        searchInfo = sample.searchInfo;
        cgiParams = sample.cgiParams;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    @Override
    public P requestParams() {
        return requestParams;
    }

    @Override
    public I searchInfo() {
        return searchInfo;
    }

    @Override
    public FutureCallback<? super D> callback() {
        return callback;
    }

    @Override
    public CgiParams cgiParams() {
        return cgiParams;
    }

    @Override
    public BasicSearchRequest<D, P, I> withCallback(
        final FutureCallback<? super D> callback)
    {
        return new BasicSearchRequest<D, P, I>(this, callback);
    }

    @Override
    public BasicSearchRequest<D, P, I> withCgiParams(
        final CgiParams cgiParams)
    {
        return new BasicSearchRequest<D, P, I>(this, cgiParams);
    }
}

