package ru.yandex.search.rules;

public class RequestInfo {
    protected final RequestType type;
    protected final String request;
    protected final String rule;

    public RequestInfo(
        final RequestType type,
        final String request,
        final String rule)
    {
        this.type = type;
        this.request = request;
        this.rule = rule;
    }

    public String request() {
        return request;
    }

    public String rule() {
        return rule;
    }

    public RequestType type() {
        return type;
    }

    @Override
    public int hashCode() {
        return request.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof RequestInfo) {
            return ((RequestInfo) o).request.equals(request);
        } else {
            return false;
        }
    }
}

