package ru.yandex.search.rules;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.uri.CgiParams;

public interface SearchRequest<
    D,
    P extends RequestParams,
    I extends SearchInfo>
{
    ProxySession session();

    P requestParams();

    I searchInfo();

    FutureCallback<? super D> callback();

    CgiParams cgiParams();

    SearchRequest<D, P, I> withCallback(FutureCallback<? super D> callback);

    SearchRequest<D, P, I> withCgiParams(CgiParams cgiParams);
}

